/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.cs;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListDescriptorImpl;
import javax.media.jai.ParameterListImpl;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.AxisOrientation;
import org.geotools.cs.CompoundCoordinateSystem;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.CoordinateSystemAuthorityFactory;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.Datum;
import org.geotools.cs.DatumType;
import org.geotools.cs.Ellipsoid;
import org.geotools.cs.FactoryException;
import org.geotools.cs.FittedCoordinateSystem;
import org.geotools.cs.GeocentricCoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.Info;
import org.geotools.cs.InfoProperties;
import org.geotools.cs.LocalCoordinateSystem;
import org.geotools.cs.LocalDatum;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.cs.VerticalCoordinateSystem;
import org.geotools.cs.VerticalDatum;
import org.geotools.cs.WGS84ConversionInfo;
import org.geotools.ct.MathTransformFactory;
import org.geotools.resources.RemoteProxy;
import org.geotools.resources.XArray;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.opengis.cs.CS_AngularUnit;
import org.opengis.cs.CS_AxisInfo;
import org.opengis.cs.CS_AxisOrientationEnum;
import org.opengis.cs.CS_CompoundCoordinateSystem;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.cs.CS_CoordinateSystemAuthorityFactory;
import org.opengis.cs.CS_CoordinateSystemFactory;
import org.opengis.cs.CS_Datum;
import org.opengis.cs.CS_DatumType;
import org.opengis.cs.CS_Ellipsoid;
import org.opengis.cs.CS_FittedCoordinateSystem;
import org.opengis.cs.CS_GeocentricCoordinateSystem;
import org.opengis.cs.CS_GeographicCoordinateSystem;
import org.opengis.cs.CS_HorizontalCoordinateSystem;
import org.opengis.cs.CS_HorizontalDatum;
import org.opengis.cs.CS_Info;
import org.opengis.cs.CS_LinearUnit;
import org.opengis.cs.CS_LocalCoordinateSystem;
import org.opengis.cs.CS_LocalDatum;
import org.opengis.cs.CS_PrimeMeridian;
import org.opengis.cs.CS_ProjectedCoordinateSystem;
import org.opengis.cs.CS_Projection;
import org.opengis.cs.CS_ProjectionParameter;
import org.opengis.cs.CS_Unit;
import org.opengis.cs.CS_VerticalCoordinateSystem;
import org.opengis.cs.CS_VerticalDatum;
import org.opengis.cs.CS_WGS84ConversionInfo;

public class Adapters
extends org.geotools.pt.Adapters {
    protected final CoordinateSystemFactory csFactory = CoordinateSystemFactory.getDefault();
    static /* synthetic */ Class class$java$lang$Double;

    protected Adapters() {
    }

    public CS_CoordinateSystemAuthorityFactory export(CoordinateSystemAuthorityFactory factory) throws RemoteException {
        return factory != null ? (CS_CoordinateSystemAuthorityFactory)factory.toOpenGIS(this) : null;
    }

    public CS_CoordinateSystemFactory export(CoordinateSystemFactory factory) throws RemoteException {
        return factory != null ? (CS_CoordinateSystemFactory)factory.toOpenGIS(this) : null;
    }

    public CS_Info export(Info info) throws RemoteException {
        return info != null ? (CS_Info)info.cachedOpenGIS(this) : null;
    }

    public CS_CoordinateSystem export(CoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_CoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_FittedCoordinateSystem export(FittedCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_FittedCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_CompoundCoordinateSystem export(CompoundCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_CompoundCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_LocalCoordinateSystem export(LocalCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_LocalCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_GeocentricCoordinateSystem export(GeocentricCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_GeocentricCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_VerticalCoordinateSystem export(VerticalCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_VerticalCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_HorizontalCoordinateSystem export(HorizontalCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_HorizontalCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_GeographicCoordinateSystem export(GeographicCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_GeographicCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_ProjectedCoordinateSystem export(ProjectedCoordinateSystem cs) throws RemoteException {
        return cs != null ? (CS_ProjectedCoordinateSystem)cs.cachedOpenGIS(this) : null;
    }

    public CS_Projection export(Projection projection) throws RemoteException {
        return projection != null ? (CS_Projection)projection.cachedOpenGIS(this) : null;
    }

    final CS_ProjectionParameter[] exportProjectionParameters(ParameterList parameters) {
        if (parameters == null) {
            return null;
        }
        String[] names = parameters.getParameterListDescriptor().getParamNames();
        Object[] param = new CS_ProjectionParameter[names != null ? names.length : 0];
        int count = 0;
        for (int i = 0; i < param.length; ++i) {
            Object value;
            String name = names[i];
            try {
                value = parameters.getObjectParameter(name);
            }
            catch (IllegalStateException exception) {
                continue;
            }
            if (!(value instanceof Number)) continue;
            param[count++] = new CS_ProjectionParameter(name, ((Number)value).doubleValue());
        }
        return (CS_ProjectionParameter[])XArray.resize((Object[])param, (int)count);
    }

    public CS_PrimeMeridian export(PrimeMeridian meridian) throws RemoteException {
        return meridian != null ? (CS_PrimeMeridian)meridian.cachedOpenGIS(this) : null;
    }

    public CS_Ellipsoid export(Ellipsoid ellipsoid) throws RemoteException {
        return ellipsoid != null ? (CS_Ellipsoid)ellipsoid.cachedOpenGIS(this) : null;
    }

    public CS_DatumType export(DatumType type) {
        return type != null ? new CS_DatumType(type.getValue()) : null;
    }

    public CS_Datum export(Datum datum) throws RemoteException {
        return datum != null ? (CS_Datum)datum.cachedOpenGIS(this) : null;
    }

    public CS_LocalDatum export(LocalDatum datum) throws RemoteException {
        return datum != null ? (CS_LocalDatum)datum.cachedOpenGIS(this) : null;
    }

    public CS_HorizontalDatum export(HorizontalDatum datum) throws RemoteException {
        return datum != null ? (CS_HorizontalDatum)datum.cachedOpenGIS(this) : null;
    }

    public CS_VerticalDatum export(VerticalDatum datum) throws RemoteException {
        return datum != null ? (CS_VerticalDatum)datum.cachedOpenGIS(this) : null;
    }

    public CS_AxisOrientationEnum export(AxisOrientation orientation) {
        return orientation != null ? new CS_AxisOrientationEnum(orientation.getValue()) : null;
    }

    public CS_AxisInfo export(AxisInfo axis) {
        return axis != null ? new CS_AxisInfo(axis.name, this.export(axis.orientation)) : null;
    }

    public CS_WGS84ConversionInfo export(WGS84ConversionInfo info) {
        if (info == null) {
            return null;
        }
        CS_WGS84ConversionInfo nf = new CS_WGS84ConversionInfo();
        nf.dx = info.dx;
        nf.dy = info.dy;
        nf.dz = info.dz;
        nf.ex = info.ex;
        nf.ey = info.ey;
        nf.ez = info.ez;
        nf.ppm = info.ppm;
        nf.areaOfUse = info.areaOfUse;
        return nf;
    }

    public CS_Unit export(Unit unit) throws RemoteException {
        if (unit == null) {
            return null;
        }
        Info info = new Info(unit.getLocalizedName());
        if (unit.canConvert(Unit.METRE)) {
            Info info2 = info;
            info2.getClass();
            return new Info.LinearUnit(info2, this, unit.convert(1.0, Unit.METRE));
        }
        if (unit.canConvert(Unit.RADIAN)) {
            Info info3 = info;
            info3.getClass();
            return new Info.AngularUnit(info3, this, unit.convert(1.0, Unit.RADIAN));
        }
        Info info4 = info;
        info4.getClass();
        return new Info.AbstractUnit(info4, this, Double.NaN);
    }

    private static void checkDimension(CS_CoordinateSystem cs, int expected) throws RemoteException, IllegalArgumentException {
        int dimension = cs.getDimension();
        if (dimension != expected) {
            throw new IllegalArgumentException(Resources.format(53, new Integer(dimension)));
        }
    }

    public Info wrap(CS_Info info) throws RemoteException {
        if (info == null) {
            return null;
        }
        if (info instanceof CS_Datum) {
            return this.wrap((CS_Datum)info);
        }
        if (info instanceof CS_CoordinateSystem) {
            return this.wrap((CS_CoordinateSystem)info);
        }
        if (info instanceof RemoteProxy) {
            return (Info)((RemoteProxy)info).getImplementation();
        }
        return new Info(new InfoProperties.Adapter(info));
    }

    public CoordinateSystem wrap(CS_CoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof CS_FittedCoordinateSystem) {
            return this.wrap((CS_FittedCoordinateSystem)cs);
        }
        if (cs instanceof CS_CompoundCoordinateSystem) {
            return this.wrap((CS_CompoundCoordinateSystem)cs);
        }
        if (cs instanceof CS_LocalCoordinateSystem) {
            return this.wrap((CS_LocalCoordinateSystem)cs);
        }
        if (cs instanceof CS_GeocentricCoordinateSystem) {
            return this.wrap((CS_GeocentricCoordinateSystem)cs);
        }
        if (cs instanceof CS_VerticalCoordinateSystem) {
            return this.wrap((CS_VerticalCoordinateSystem)cs);
        }
        if (cs instanceof CS_HorizontalCoordinateSystem) {
            return this.wrap((CS_HorizontalCoordinateSystem)cs);
        }
        if (cs instanceof RemoteProxy) {
            return (CoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        throw new UnsupportedOperationException("Unknow CS not yet implemented");
    }

    public FittedCoordinateSystem wrap(CS_FittedCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (FittedCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        try {
            return this.csFactory.createFittedCoordinateSystem(new InfoProperties.Adapter((CS_Info)cs), this.wrap(cs.getBaseCoordinateSystem()), MathTransformFactory.getDefault().createFromWKT(cs.getToBase()), null);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public CompoundCoordinateSystem wrap(CS_CompoundCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (CompoundCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        try {
            return this.csFactory.createCompoundCoordinateSystem(new InfoProperties.Adapter((CS_Info)cs), this.wrap(cs.getHeadCS()), this.wrap(cs.getTailCS()));
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public LocalCoordinateSystem wrap(CS_LocalCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (LocalCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        LocalDatum datum = this.wrap(cs.getLocalDatum());
        Unit[] units = new Unit[cs.getDimension()];
        AxisInfo[] axes = new AxisInfo[units.length];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = this.wrap(cs.getAxis(i));
            units[i] = this.wrap(cs.getUnits(i));
        }
        try {
            return this.csFactory.createLocalCoordinateSystem((CharSequence)new InfoProperties.Adapter((CS_Info)cs), datum, units, axes);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public GeocentricCoordinateSystem wrap(CS_GeocentricCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (GeocentricCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        Adapters.checkDimension((CS_CoordinateSystem)cs, 3);
        Unit unit = this.wrap((CS_Unit)cs.getLinearUnit());
        HorizontalDatum datum = this.wrap(cs.getHorizontalDatum());
        PrimeMeridian meridian = this.wrap(cs.getPrimeMeridian());
        AxisInfo[] axes = new AxisInfo[cs.getDimension()];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = this.wrap(cs.getAxis(i));
        }
        try {
            return this.csFactory.createGeocentricCoordinateSystem(new InfoProperties.Adapter((CS_Info)cs), unit, datum, meridian, axes);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public VerticalCoordinateSystem wrap(CS_VerticalCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (VerticalCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        Adapters.checkDimension((CS_CoordinateSystem)cs, 1);
        VerticalDatum datum = this.wrap(cs.getVerticalDatum());
        Unit unit = this.wrap((CS_Unit)cs.getVerticalUnit());
        AxisInfo axis = this.wrap(cs.getAxis(0));
        try {
            return this.csFactory.createVerticalCoordinateSystem(new InfoProperties.Adapter((CS_Info)cs), datum, unit, axis);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public HorizontalCoordinateSystem wrap(CS_HorizontalCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof CS_GeographicCoordinateSystem) {
            return this.wrap((CS_GeographicCoordinateSystem)cs);
        }
        if (cs instanceof CS_ProjectedCoordinateSystem) {
            return this.wrap((CS_ProjectedCoordinateSystem)cs);
        }
        if (cs instanceof RemoteProxy) {
            return (HorizontalCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        throw new UnsupportedOperationException("Unknown CS not yet implemented");
    }

    public GeographicCoordinateSystem wrap(CS_GeographicCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (GeographicCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        Adapters.checkDimension((CS_CoordinateSystem)cs, 2);
        Unit unit = this.wrap((CS_Unit)cs.getAngularUnit());
        HorizontalDatum datum = this.wrap(cs.getHorizontalDatum());
        PrimeMeridian meridian = this.wrap(cs.getPrimeMeridian());
        AxisInfo axis0 = this.wrap(cs.getAxis(0));
        AxisInfo axis1 = this.wrap(cs.getAxis(1));
        try {
            return this.csFactory.createGeographicCoordinateSystem(new InfoProperties.Adapter((CS_Info)cs), unit, datum, meridian, axis0, axis1);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public ProjectedCoordinateSystem wrap(CS_ProjectedCoordinateSystem cs) throws RemoteException {
        if (cs == null) {
            return null;
        }
        if (cs instanceof RemoteProxy) {
            return (ProjectedCoordinateSystem)((RemoteProxy)cs).getImplementation();
        }
        Adapters.checkDimension((CS_CoordinateSystem)cs, 2);
        GeographicCoordinateSystem gcs = this.wrap(cs.getGeographicCoordinateSystem());
        Projection projection = this.wrap(cs.getProjection());
        Unit unit = this.wrap((CS_Unit)cs.getLinearUnit());
        AxisInfo axis0 = this.wrap(cs.getAxis(0));
        AxisInfo axis1 = this.wrap(cs.getAxis(1));
        try {
            return this.csFactory.createProjectedCoordinateSystem(new InfoProperties.Adapter((CS_Info)cs), gcs, projection, unit, axis0, axis1);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public Projection wrap(CS_Projection projection) throws RemoteException {
        if (projection == null) {
            return null;
        }
        if (projection instanceof RemoteProxy) {
            return (Projection)((RemoteProxy)projection).getImplementation();
        }
        CS_ProjectionParameter[] parameters = new CS_ProjectionParameter[projection.getNumParameters()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = projection.getParameter(i);
        }
        try {
            return this.csFactory.createProjection(new InfoProperties.Adapter((CS_Info)projection), projection.getClassName(), this.wrap(parameters));
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public PrimeMeridian wrap(CS_PrimeMeridian meridian) throws RemoteException {
        if (meridian == null) {
            return null;
        }
        if (meridian instanceof RemoteProxy) {
            return (PrimeMeridian)((RemoteProxy)meridian).getImplementation();
        }
        try {
            return this.csFactory.createPrimeMeridian(new InfoProperties.Adapter((CS_Info)meridian), this.wrap((CS_Unit)meridian.getAngularUnit()), meridian.getLongitude());
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public Ellipsoid wrap(CS_Ellipsoid ellipsoid) throws RemoteException {
        if (ellipsoid == null) {
            return null;
        }
        if (ellipsoid instanceof RemoteProxy) {
            return (Ellipsoid)((RemoteProxy)ellipsoid).getImplementation();
        }
        InfoProperties.Adapter name = new InfoProperties.Adapter((CS_Info)ellipsoid);
        double semiMajorAxis = ellipsoid.getSemiMajorAxis();
        double semiMinorAxis = ellipsoid.getSemiMinorAxis();
        double inverseFlattening = ellipsoid.getInverseFlattening();
        boolean ivfDefinitive = ellipsoid.isIvfDefinitive();
        Unit units = this.wrap((CS_Unit)ellipsoid.getAxisUnit());
        try {
            if (ivfDefinitive) {
                return this.csFactory.createFlattenedSphere(name, semiMajorAxis, inverseFlattening, units);
            }
            return this.csFactory.createEllipsoid(name, semiMajorAxis, semiMinorAxis, units);
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public DatumType wrap(CS_DatumType type) {
        return type != null ? DatumType.getEnum(type.value) : null;
    }

    public Datum wrap(CS_Datum datum) throws RemoteException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof CS_LocalDatum) {
            return this.wrap((CS_LocalDatum)datum);
        }
        if (datum instanceof CS_VerticalDatum) {
            return this.wrap((CS_VerticalDatum)datum);
        }
        if (datum instanceof CS_HorizontalDatum) {
            return this.wrap((CS_HorizontalDatum)datum);
        }
        if (datum instanceof RemoteProxy) {
            return (Datum)((RemoteProxy)datum).getImplementation();
        }
        return new Datum(new InfoProperties.Adapter((CS_Info)datum), this.wrap(datum.getDatumType()));
    }

    public LocalDatum wrap(CS_LocalDatum datum) throws RemoteException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof RemoteProxy) {
            return (LocalDatum)((RemoteProxy)datum).getImplementation();
        }
        try {
            return this.csFactory.createLocalDatum(new InfoProperties.Adapter((CS_Info)datum), (DatumType.Local)this.wrap(datum.getDatumType()));
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public HorizontalDatum wrap(CS_HorizontalDatum datum) throws RemoteException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof RemoteProxy) {
            return (HorizontalDatum)((RemoteProxy)datum).getImplementation();
        }
        try {
            return this.csFactory.createHorizontalDatum(new InfoProperties.Adapter((CS_Info)datum), (DatumType.Horizontal)this.wrap(datum.getDatumType()), this.wrap(datum.getEllipsoid()), this.wrap(datum.getWGS84Parameters()));
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public VerticalDatum wrap(CS_VerticalDatum datum) throws RemoteException {
        if (datum == null) {
            return null;
        }
        if (datum instanceof RemoteProxy) {
            return (VerticalDatum)((RemoteProxy)datum).getImplementation();
        }
        try {
            return this.csFactory.createVerticalDatum(new InfoProperties.Adapter((CS_Info)datum), (DatumType.Vertical)this.wrap(datum.getDatumType()));
        }
        catch (FactoryException exception) {
            throw Adapters.serverException(exception);
        }
    }

    public AxisOrientation wrap(CS_AxisOrientationEnum orientation) {
        return orientation != null ? AxisOrientation.getEnum(orientation.value) : null;
    }

    public AxisInfo wrap(CS_AxisInfo axis) {
        return axis != null ? new AxisInfo(axis.name, this.wrap(axis.orientation)) : null;
    }

    final AxisInfo[] wrap(CS_AxisInfo[] axis) {
        if (axis == null) {
            return null;
        }
        AxisInfo[] a = new AxisInfo[axis.length];
        for (int i = 0; i < axis.length; ++i) {
            a[i] = this.wrap(axis[i]);
        }
        return a;
    }

    public ParameterList wrap(CS_ProjectionParameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        int count = 0;
        Object[] paramNames = new String[parameters.length];
        Object[] paramClasses = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            CS_ProjectionParameter param = parameters[i];
            if (param == null) continue;
            paramNames[count] = param.name;
            paramClasses[count] = class$java$lang$Double == null ? Adapters.class$("java.lang.Double") : class$java$lang$Double;
            ++count;
        }
        paramNames = (String[])XArray.resize((Object[])paramNames, (int)count);
        paramClasses = (Class[])XArray.resize((Object[])paramClasses, (int)count);
        ParameterListImpl list = new ParameterListImpl((ParameterListDescriptor)new ParameterListDescriptorImpl(null, (String[])paramNames, (Class[])paramClasses, null, null));
        for (int i = 0; i < paramNames.length; ++i) {
            list.setParameter((String)paramNames[i], parameters[i].value);
        }
        return list;
    }

    public WGS84ConversionInfo wrap(CS_WGS84ConversionInfo info) {
        if (info == null) {
            return null;
        }
        WGS84ConversionInfo nf = new WGS84ConversionInfo();
        nf.dx = info.dx;
        nf.dy = info.dy;
        nf.dz = info.dz;
        nf.ex = info.ex;
        nf.ey = info.ey;
        nf.ez = info.ez;
        nf.ppm = info.ppm;
        nf.areaOfUse = info.areaOfUse;
        return nf;
    }

    public Unit wrap(CS_Unit unit) throws RemoteException {
        if (unit == null) {
            return null;
        }
        if (unit instanceof CS_LinearUnit) {
            double metersPerUnit = ((CS_LinearUnit)unit).getMetersPerUnit();
            return Unit.METRE.scale(metersPerUnit);
        }
        if (unit instanceof CS_AngularUnit) {
            double radiansPerUnit = ((CS_AngularUnit)unit).getRadiansPerUnit();
            return Unit.RADIAN.scale(radiansPerUnit);
        }
        throw new UnsupportedOperationException("Only meters and degrees are currently implemented");
    }

    static RemoteException serverException(FactoryException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException) {
            return (RemoteException)cause;
        }
        return new ServerException("Can't create object", exception);
    }
}

