/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.text.NumberFormat;
import java.util.Locale;
import org.geotools.axis.AbstractGraduation;
import org.geotools.axis.TickIterator;
import org.geotools.resources.XMath;

class NumberIterator
implements TickIterator {
    private static final double EPS = 1.0E-8;
    private double minimum;
    private double maximum;
    private double increment;
    private float visualLength;
    private float visualTickSpacing;
    private int subTickCount;
    private int subTickStart;
    private int tickIndex;
    private int subTickIndex;
    private double value;
    private transient NumberFormat format;
    private transient boolean formatValid;
    private Locale locale;

    protected NumberIterator(Locale locale) {
        this.locale = locale;
    }

    protected void init(double minimum, double maximum, float visualLength, float visualTickSpacing) {
        int subTickCount;
        if (minimum == this.minimum && maximum == this.maximum && visualLength == this.visualLength && visualTickSpacing == this.visualTickSpacing) {
            this.rewind();
            return;
        }
        AbstractGraduation.ensureFinite("minimum", minimum);
        AbstractGraduation.ensureFinite("maximum", maximum);
        AbstractGraduation.ensureFinite("visualLength", visualLength);
        AbstractGraduation.ensureNonNull("visualTickSpacing", visualTickSpacing);
        this.visualLength = visualLength;
        this.visualTickSpacing = visualTickSpacing;
        double increment = (maximum - minimum) * (double)(visualTickSpacing / visualLength);
        double factor = XMath.pow10((int)((int)Math.floor(XMath.log10((double)increment))));
        if (Double.isNaN(increment /= factor) || Double.isInfinite(increment) || increment == 0.0) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.increment = Double.NaN;
            this.value = Double.NaN;
            this.tickIndex = 0;
            this.subTickIndex = 0;
            this.subTickStart = 0;
            this.subTickCount = 1;
            this.formatValid = false;
            return;
        }
        if (increment <= 1.0) {
            increment = 1.0;
            subTickCount = 5;
        } else if (increment <= 2.0) {
            increment = 2.0;
            subTickCount = 4;
        } else if (increment <= 2.5) {
            increment = 2.5;
            subTickCount = 5;
        } else if (increment <= 4.0) {
            increment = 4.0;
            subTickCount = 4;
        } else if (increment <= 5.0) {
            increment = 5.0;
            subTickCount = 5;
        } else {
            increment = 10.0;
            subTickCount = 5;
        }
        double tmp = minimum;
        minimum = Math.floor(minimum / (increment *= factor) + 1.0E-8) * increment;
        int subTickStart = (int)Math.ceil((tmp - minimum - 1.0E-8) * ((double)subTickCount / increment));
        int extra = subTickStart / subTickCount;
        this.increment = increment;
        this.subTickCount = subTickCount;
        this.maximum = maximum + Math.abs(maximum * 1.0E-8);
        this.minimum = minimum += (double)extra * increment;
        this.subTickStart = subTickStart -= extra * subTickCount;
        this.subTickIndex = subTickStart;
        this.tickIndex = 0;
        this.value = minimum + increment * ((double)subTickStart / (double)subTickCount);
        this.formatValid = false;
    }

    public boolean hasNext() {
        return this.value <= this.maximum;
    }

    public boolean isMajorTick() {
        return this.subTickIndex == 0;
    }

    public double currentPosition() {
        return this.value;
    }

    public double currentValue() {
        return this.value;
    }

    public String currentLabel() {
        if (!this.formatValid) {
            double check;
            int precision;
            if (this.format == null) {
                this.format = NumberFormat.getNumberInstance(this.locale);
            }
            double step = Math.abs(this.increment);
            for (precision = 0; precision < 6 && (check = Math.rint(step * 10000.0) % 10000.0) > step * 1.0E-8; ++precision) {
                step *= 10.0;
            }
            this.format.setMinimumFractionDigits(precision);
            this.format.setMaximumFractionDigits(precision);
            this.formatValid = true;
        }
        return this.format.format(this.currentValue());
    }

    public void next() {
        if (++this.subTickIndex >= this.subTickCount) {
            this.subTickIndex = 0;
            ++this.tickIndex;
        }
        this.value = this.minimum + this.increment * ((double)this.tickIndex + (double)this.subTickIndex / (double)this.subTickCount);
    }

    public void nextMajor() {
        this.subTickIndex = 0;
        this.value = this.minimum + this.increment * (double)(++this.tickIndex);
    }

    public void rewind() {
        this.tickIndex = 0;
        this.subTickIndex = this.subTickStart;
        this.value = this.minimum + this.increment * ((double)this.subTickStart / (double)this.subTickCount);
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setLocale(Locale locale) {
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            this.format = null;
            this.formatValid = false;
        }
    }
}

