/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.axis;

import java.awt.RenderingHints;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.axis.AbstractGraduation;
import org.geotools.axis.DateIterator;
import org.geotools.axis.TickIterator;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;

public class DateGraduation
extends AbstractGraduation {
    private static final long serialVersionUID = -7590383805990568769L;
    private long minimum = System.currentTimeMillis();
    private long maximum = this.minimum + 86400000L;
    private TimeZone timezone;

    public DateGraduation(TimeZone timezone) {
        this(timezone, Unit.MILLISECOND);
    }

    public DateGraduation(TimeZone timezone, Unit unit) throws UnitException {
        super(unit);
        DateGraduation.ensureTimeUnit(unit);
        this.timezone = (TimeZone)timezone.clone();
    }

    private static void ensureTimeUnit(Unit unit) throws UnitException {
        if (unit == null || !Unit.MILLISECOND.canConvert(unit)) {
            throw new UnitException(Resources.format(91, "unit", unit));
        }
    }

    public synchronized boolean setMinimum(Date time) {
        long value = time.getTime();
        long old = this.minimum;
        this.minimum = value;
        this.firePropertyChange("minimum", old, time);
        if (this.maximum < value) {
            old = this.maximum;
            this.maximum = value;
            this.firePropertyChange("maximum", old, time);
            return true;
        }
        return value != old;
    }

    public synchronized boolean setMaximum(Date time) {
        long value = time.getTime();
        long old = this.maximum;
        this.maximum = value;
        this.firePropertyChange("maximum", old, time);
        if (this.minimum > value) {
            old = this.minimum;
            this.minimum = value;
            this.firePropertyChange("minimum", old, time);
            return true;
        }
        return value != old;
    }

    public final synchronized boolean setMinimum(double value) {
        DateGraduation.ensureFinite("minimum", value);
        return this.setMinimum(new Date(Math.round(Unit.MILLISECOND.convert(value, this.getUnit()))));
    }

    public final synchronized boolean setMaximum(double value) {
        DateGraduation.ensureFinite("maximum", value);
        return this.setMaximum(new Date(Math.round(Unit.MILLISECOND.convert(value, this.getUnit()))));
    }

    public double getMinimum() {
        return this.getUnit().convert((double)this.minimum, Unit.MILLISECOND);
    }

    public double getMaximum() {
        return this.getUnit().convert((double)this.maximum, Unit.MILLISECOND);
    }

    public synchronized double getRange() {
        Unit unit = this.getUnit();
        if (unit == Unit.MILLISECOND) {
            return this.maximum - this.minimum;
        }
        return unit.convert((double)this.maximum, Unit.MILLISECOND) - unit.convert((double)this.minimum, Unit.MILLISECOND);
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setTimeZone(TimeZone timezone) {
        this.timezone = (TimeZone)timezone.clone();
    }

    String getSymbol() {
        return this.getTimeZone().getDisplayName();
    }

    public void setUnit(Unit unit) throws UnitException {
        DateGraduation.ensureTimeUnit(unit);
        super.setUnit(unit);
    }

    public Format getFormat() {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3, this.getLocale());
        format.setTimeZone(this.timezone);
        return format;
    }

    public synchronized TickIterator getTickIterator(RenderingHints hints, TickIterator reuse) {
        DateIterator it;
        float visualAxisLength = DateGraduation.getVisualAxisLength(hints);
        float visualTickSpacing = DateGraduation.getVisualTickSpacing(hints);
        long minimum = this.minimum;
        long maximum = this.maximum;
        if (minimum >= maximum) {
            minimum = (minimum + maximum) / 2L - 43200000L;
            maximum = minimum + 86400000L;
        }
        if (reuse instanceof DateIterator) {
            it = (DateIterator)reuse;
            it.setLocale(this.getLocale());
            it.setTimeZone(this.getTimeZone());
        } else {
            it = new DateIterator(this.getTimeZone(), this.getLocale());
        }
        it.init(minimum, maximum, visualAxisLength, visualTickSpacing);
        return it;
    }

    private final void firePropertyChange(String propertyName, long oldValue, Date newValue) {
        if (oldValue != newValue.getTime()) {
            this.listenerList.firePropertyChange(propertyName, new Date(oldValue), newValue);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DateGraduation that = (DateGraduation)object;
            return this.minimum == that.minimum && this.maximum == that.maximum && Utilities.equals((Object)this.timezone, (Object)that.timezone);
        }
        return false;
    }

    public int hashCode() {
        long lcode = this.minimum + 37L * this.maximum;
        int code = (int)lcode ^ (int)(lcode >>> 32);
        if (this.timezone != null) {
            code ^= this.timezone.hashCode();
        }
        return code ^ super.hashCode();
    }
}

