/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.gt2jump.geomconv;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import de.soldin.gt2jump.UndoableSetGeometry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.undo.UndoableEdit;

public class GCPlugin
implements PlugIn,
ActionListener {
    private String NAME = "Convert Selected Geometry to";
    private WorkbenchContext wbc;
    private GeometryFactory factory = new GeometryFactory();
    private String lastcmd = "";

    public void initialize(PlugInContext context) throws Exception {
        this.wbc = context.getWorkbenchContext();
        ArrayList types = new ArrayList(this.getCreatableGeoms().keySet());
        Collections.sort(types);
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            String string = (String)iter.next();
            context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{"Edit", this.getName()}, string, false, null, this.createEnableCheck(context));
        }
        JMenu menu = context.getFeatureInstaller().menuBarMenu("Edit");
        this.addMenuListener(menu, this.createEnableCheck(context));
        int i = 0;
        while (i < menu.getItemCount()) {
            if (menu.getItem(i) != null && menu.getItem(i).getText().equals(this.getName())) {
                JMenu submenu;
                try {
                    submenu = (JMenu)menu.getItem(i);
                }
                catch (ClassCastException cexc) {
                    context.getWorkbenchContext().getErrorHandler().handleThrowable((Throwable)new Exception("Menuitem '" + this.getName() + "' is an unexpected object type."));
                    return;
                }
                int j = 0;
                while (j < submenu.getItemCount()) {
                    submenu.getItem(j).addActionListener(this);
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            this.lastcmd = e.getActionCommand();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
        Method method = (Method)this.getCreatableGeoms().get(this.lastcmd);
        Class<?>[] cparams = method.getParameterTypes();
        Collection feats = this.getFeatures();
        UndoableSetGeometry action = new UndoableSetGeometry((Layer)this.getLayers().iterator().next(), this.getName());
        try {
            Geometry geom_new;
            Feature feat;
            block13: {
                Geometry geom_src;
                block14: {
                    if (feats.size() < 1) {
                        context.getLayerViewPanel().getContext().warnUser("No feature selected!");
                        return false;
                    }
                    if (feats.size() != 1) {
                        context.getLayerViewPanel().getContext().warnUser("Conversion of more than one feature not supported by now.");
                        return true;
                    }
                    feat = (Feature)feats.iterator().next();
                    geom_src = action.getGeom(feat);
                    geom_new = null;
                    if (cparams.length != 1) break block14;
                    if (cparams[0].getName().equals("com.vividsolutions.jts.geom.Coordinate")) {
                        if (geom_src.getCoordinates().length != 1) {
                            context.getLayerViewPanel().getContext().warnUser("Too many points selected. Only one point needed.");
                            return false;
                        }
                        geom_new = (Geometry)method.invoke((Object)this.factory, geom_src.getCoordinates()[0]);
                        break block13;
                    } else if (cparams[0].isArray() && cparams[0].getComponentType().getName().equals("com.vividsolutions.jts.geom.Coordinate")) {
                        geom_new = (Geometry)method.invoke((Object)this.factory, new Object[]{action.getGeom(feat).getCoordinates()});
                        break block13;
                    } else {
                        context.getLayerViewPanel().getContext().warnUser("This conversion '" + this.lastcmd + "' is not implemented by now!");
                        return false;
                    }
                }
                if (cparams.length > 1) {
                    if (!cparams[0].getName().equals("com.vividsolutions.jts.geom.LinearRing")) {
                        context.getLayerViewPanel().getContext().warnUser("This conversion '" + this.lastcmd + "' is not implemented by now!");
                        return false;
                    }
                    if (!(geom_src instanceof LinearRing)) {
                        Method method2 = (Method)this.getCreatableGeoms().get("LinearRing");
                        geom_src = (Geometry)method2.invoke((Object)this.factory, new Object[]{geom_src.getCoordinates()});
                    }
                    if (!(geom_src instanceof LinearRing)) {
                        context.getLayerViewPanel().getContext().warnUser("Selected features geometry is no '" + cparams[0].getName() + "'.");
                        return false;
                    }
                    Object[] params = new Object[cparams.length];
                    params[0] = geom_src;
                    geom_new = (Geometry)method.invoke((Object)this.factory, params);
                }
            }
            if (geom_new == null) return true;
            action.setGeom(feat, geom_new);
            action.execute();
            this.wbc.getLayerManager().getUndoableEditReceiver().receive((UndoableEdit)action);
            return true;
        }
        catch (InvocationTargetException ie) {
            if (ie.getCause() == null) return true;
            context.getLayerViewPanel().getContext().warnUser(ie.getCause().getLocalizedMessage());
        }
        return true;
    }

    public String getName() {
        return this.NAME;
    }

    public EnableCheck createEnableCheck(PlugInContext context) {
        MultiEnableCheck checker = new MultiEnableCheck();
        checker.add(new EnableCheck(){

            public String check(JComponent component) {
                return null;
            }
        });
        MultiEnableCheck checker2 = new MultiEnableCheck();
        checker2.add(new EnableCheck(){

            public String check(JComponent component) {
                boolean featureok = GCPlugin.this.getFeatures().size() == 1;
                return featureok ? null : "Exactly one feature in one layer must be selected for conversion.";
            }
        });
        checker2.add(new EnableCheck(){

            public String check(JComponent component) {
                boolean editable = ((Layer)GCPlugin.this.getLayers().iterator().next()).isEditable();
                return editable ? null : "Selected layer is not editable.";
            }
        });
        checker.add((EnableCheck)checker2);
        return checker;
    }

    public EnableCheck createEnableCheckMenu(PlugInContext context) {
        EnableCheck check = new EnableCheck(){

            public String check(JComponent component) {
                Component[] comps = component.getComponents();
                int i = 0;
                while (i < comps.length) {
                    if (comps[i].isEnabled()) {
                        return null;
                    }
                    ++i;
                }
                return "";
            }
        };
        return check;
    }

    public void addMenuListener(final JMenu menu, final EnableCheck enableCheck) {
        Component[] comps = menu.getMenuComponents();
        JMenuItem item = null;
        int i = 0;
        while (i < comps.length) {
            try {
                JMenuItem pitem = (JMenuItem)comps[i];
                if (pitem.getText().equals(this.getName())) {
                    item = (JMenuItem)comps[i];
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        if (item == null) {
            this.wbc.getErrorHandler().handleThrowable((Throwable)new Exception("Could not find menu item '" + this.getName() + "' in menu '" + menu.getName() + "'."));
            return;
        }
        final JMenuItem item2 = item;
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                String errorMessage = null;
                try {
                    errorMessage = enableCheck.check((JComponent)menu);
                }
                catch (Exception ex) {
                    GCPlugin.this.wbc.getWorkbench().getFrame().handleThrowable((Throwable)ex);
                }
                if (errorMessage != null) {
                    item2.setEnabled(false);
                    item2.setToolTipText(errorMessage);
                    return;
                }
                item2.setEnabled(true);
                item2.setToolTipText(null);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private Collection getFeatures() {
        return ((SelectionManagerProxy)this.wbc.getWorkbench().getFrame().getActiveInternalFrame()).getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems();
    }

    private Collection getLayers() {
        List<Layer> layers = ((SelectionManagerProxy)this.wbc.getWorkbench().getFrame().getActiveInternalFrame()).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
        return layers.isEmpty() ? Arrays.asList(this.wbc.getLayerNamePanel().getSelectedLayers()) : layers;
    }

    private Map getCreatableGeoms() throws ClassNotFoundException {
        Hashtable<String, Method> geoms = new Hashtable<String, Method>();
        Class<?> cfactory = this.factory.getClass();
        Method[] methods = cfactory.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().startsWith("create")) {
                Class<?>[] cparams = methods[i].getParameterTypes();
                boolean wrong = false;
                int j = 0;
                while (j < cparams.length) {
                    Class<?> cparam = cparams[j];
                    if (!this.validType(cparam)) {
                        wrong = true;
                        break;
                    }
                    ++j;
                }
                if (!wrong) {
                    geoms.put(method.getName().replaceFirst("create", ""), method);
                }
            }
            ++i;
        }
        return geoms;
    }

    private boolean validType(Class clazz) {
        String name = clazz.isArray() ? clazz.getComponentType().getName() : clazz.getName();
        return name.equals("com.vividsolutions.jts.geom.Coordinate") || name.equals("com.vividsolutions.jts.geom.LinearRing");
    }
}

